#!/usr/bin/perl
#
# -- 2023/02/08 --
#
# Remove the PHP module. We're tired of force updating every time Nessus finds yet another
# little security flaw whatever the fuck. The V4 interface now provides an index.cgi to
# read and emit a redirect from the index.php file.
#
# -- OLD BEHAVIOR --
# Fix php module reference in .conf
# Refer to libphp.so not libphp5.so

my $conf = "/usr/apache/conf/httpd.conf";
my $confdir = "/usr/apache/conf.d";

system("mkdir -p $confdir") == 0 || die;

my $do_patch = 0;
my @nconf = ( );

open(X,"<",$conf) || die;
while (my $line = <X>) {
    chomp $line;

    # No more PHP module, good riddance
    if ($line =~ m/^[ \t]*LoadModule[ \t]+php[0-9]*_module[ \t]+\/usr\/apache\/modules\/libphp[0-9]*\.so[ \t]*$/i) {
        print "Removing PHP module reference in configuration file.\n";
        $line = "#".$line; # comment it out
        $do_patch = 1;
    }
    # remove the directive that says to check for index.php for a directory
    # such as "DirectoryIndex index.cgi index.php index.html"
    if ($line =~ m/^[ \t]*DirectoryIndex[ \t]+/i) {
        my $oline = $line;
        if ($line =~ s/[ \t]+index\.php[ \t]+/ / || $line =~ s/[ \t]+index\.php$/ /) {
            $do_patch = 1;
            print "Removing index.php reference from configuration file.\n";
            push(@nconf,"#".$oline); # make sure the old line is shown commented out
        }
    }

    push(@nconf,$line);
}
close(X);

exit 0 if $do_patch == 0;

open(X,">","$conf.tmp") || die;
for ($i=0;$i < @nconf;$i++) {
	my $line = $nconf[$i];
	print X "$line\n";
}
close(X);
rename("$conf.tmp",$conf) || die;

