#!/usr/bin/perl
#
# Ugh, vsftpd changed what is default, so now the latest versions will act as if
# both IPv4 enable and IPv6 enable are set and give up.
my $file = "/etc/vsftpd.conf";

exit 0 unless -f $file; # exit if not a file
exit 0 if -l $file; # exit if symlink

my @nf = ( );
my $nf_write = 0;

open(IF,"<",$file) || exit 1;
@nf = grep { chomp $_ } <IF>;
close(IF);

my $listen = undef;
my $listen_line = undef;
my $listen_ipv6 = undef;
my $listen_ipv6_line = undef;
for ($i=0;$i < @nf;$i++) {
    my $line = $nf[$i];

    if ($line =~ m/^#{0,1} *LISTEN=/i) {
        $listen_line = $i;
        $listen = $line;
    }
    if ($line =~ m/^#{0,1} *LISTEN_IPv6=/i) {
        $listen_ipv6_line = $i;
        $listen_ipv6 = $line;
    }
}

if ($listen_line >= 0 && $listen =~ m/^#/) { # if listen= is commented out, vsftpd will assume yes
    if ($listen_ipv6_line >= 0 && $listen_ipv6 !~ m/^#/) { # if listen_ipv6= is not commented out, vsftpd will complain that you're trying to enable both
        if ($listen_ipv6 =~ m/^ *LISTEN_IPV6 *= *YES/i) { # user wants IPV6
            # to solve this, change the line "#listen=yes" to "listen=NO"
            $nf[$listen_line] = "listen=NO";
            $nf_write = 1;
        }
    }
}

exit 0 if $nf_write == 0;

print "Fixing vsftpd.conf...\n";

open(OF,">","$file.tmp") || exit 1;
for ($i=0;$i < @nf;$i++) {
    print OF $nf[$i]."\n";
}
close(OF);
rename("$file.tmp",$file) || exit 1;
exit 0;
