#!/usr/bin/perl
#
# Check Castus 4 inputs to see if any are running, and if so, if any are recording.
# We want our update script to be able to warn before updating if any recordings
# are running.

my %input_hung;
my %input_running;
my %input_recording;
my $line,$input,$marker,$nameval,$name,$value,$running;

# subroutine
sub shellesc($) {
    my $str = $_[0];

    $str =~ s/([^a-zA-Z0-9])/\\$1/gc;

    return $str;
}

# First: ask the inputs if they are running
open(CTL,"c4mi_inctl --timeout 4 -c list |") || die;
while ($line=<CTL>) {
    chomp $line;

    if ($line =~ m/^.*{$/) {
        $input = substr($line,0,length($line)-1);
    }
    elsif ($line eq "}") {
        $input = undef;
    }
    elsif ($line =~ s/^\t//) {
        if (defined($input)) {
            # <tab><marker><tab>name=value
            ($marker,$nameval) = split(/\t/,$line,2);
            ($name,$value) = split(/=/,$nameval,2);

            if ($marker eq "*" && $name eq "running") {
                $input_running{$input} = $value;
            }
        }
    }
}
close(CTL);

# any input that is running, ask it if it is recording
while (($input,$running) = each(%input_running)) {
    if ($running eq "1") {
        # ask if recording
        open(CTL,"c4mi_command --file /mnt/main/tv/inputs/".shellesc($input)." -c 'recording status' 2>/dev/null |") || die;
        while ($line=<CTL>) {
            chomp $line;

            ($name,$value) = split(/: /,$line,2);

            if ($name eq "recording") {
                $input_recording{$input} = $value;
            }
        }
        close(CTL);
    }
    elsif (substr($running,0,1) eq "1") {
        # note it's hung
        $input_hung{$input} = 1;
    }
}

# so then if any are hung or recording, print them out, then exit error code 60.
# the update script will then ask "ARE YOU SURE???"
my $prompt = 0;

while (($input,$running) = each(%input_running)) {
    if (exists($input_recording{$input}) && defined($input_recording{$input}) && $input_recording{$input} ne "0") {
        print "Input '".$input."' is recording!\n";
        $prompt = 1;
    }
    elsif (exists($input_hung{$input}) && defined($input_hung{$input}) && $input_hung{$input} ne "0") {
        print "Input '".$input."' is hung (not responding).\n";
        $prompt = 1;
    }
    elsif ($running ne "0") {
        print "Input '".$input."' is running.\n";
    }
}

exit 60 if $prompt;

exit 0;


